-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema restaurant
--

-- CREATE DATABASE IF NOT EXISTS restaurant;
-- USE restaurant;

--
-- Definition of table `consumido`
--

DROP TABLE IF EXISTS `consumido`;
CREATE TABLE `consumido` (
  `id_consumido` int(11) NOT NULL AUTO_INCREMENT,
  `factura_id` int(11) NOT NULL,
  `grupo_id` int(11) NOT NULL,
  `producto_id` int(11) NOT NULL,
  `cantidad` int(11) NOT NULL,
  `precio` decimal(10,2) NOT NULL,
  `valor` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id_consumido`),
  KEY `fk_consumido_factura1_idx` (`factura_id`),
  KEY `fk_consumido_producto1_idx` (`producto_id`),
  KEY `fk_consumido_grupo1_idx` (`grupo_id`),
  CONSTRAINT `fk_consumido_factura1` FOREIGN KEY (`factura_id`) REFERENCES `factura` (`id_factura`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_consumido_grupo1` FOREIGN KEY (`grupo_id`) REFERENCES `grupo` (`id_grupo`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_consumido_producto1` FOREIGN KEY (`producto_id`) REFERENCES `producto` (`id_producto`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `consumido`
--

/*!40000 ALTER TABLE `consumido` DISABLE KEYS */;
INSERT INTO `consumido` (`id_consumido`,`factura_id`,`grupo_id`,`producto_id`,`cantidad`,`precio`,`valor`) VALUES 
 (10,5,1,2,4,'2.00','8.00'),
 (11,5,1,1,3,'2.50','7.50'),
 (12,4,2,3,2,'3.50','7.00'),
 (13,5,2,3,2,'3.50','7.00'),
 (14,5,1,2,3,'2.00','6.00'),
 (15,5,3,4,3,'3.00','9.00'),
 (16,5,1,1,3,'2.50','7.50'),
 (17,7,1,2,3,'2.00','6.00'),
 (18,8,1,2,4,'2.00','8.00'),
 (19,8,3,4,2,'3.00','6.00'),
 (20,4,9,6,1,'8.00','8.00'),
 (21,4,4,2,3,'2.00','6.00'),
 (22,4,4,5,3,'2.50','7.50'),
 (23,4,9,3,1,'3.50','3.50'),
 (24,4,5,8,1,'4.00','4.00'),
 (25,4,6,10,2,'3.50','7.00'),
 (26,4,6,9,1,'5.00','5.00'),
 (27,4,7,11,3,'8.00','24.00'),
 (28,4,3,4,3,'3.00','9.00'),
 (29,9,1,1,3,'2.50','7.50'),
 (30,9,4,2,3,'2.00','6.00'),
 (31,9,9,6,1,'8.00','8.00'),
 (32,9,9,3,1,'3.50','3.50'),
 (33,10,6,10,2,'3.50','7.00'),
 (34,10,7,11,2,'8.00','16.00'),
 (35,10,3,13,1,'3.75','3.75'),
 (36,10,3,4,1,'3.00','3.00'),
 (37,10,1,1,2,'2.50','5.00'),
 (38,10,3,13,2,'3.75','7.50'),
 (39,10,4,2,2,'2.00','4.00'),
 (40,11,4,5,4,'2.50','10.00'),
 (41,10,1,1,3,'2.50','7.50'),
 (42,10,1,1,4,'2.50','10.00');
/*!40000 ALTER TABLE `consumido` ENABLE KEYS */;


--
-- Definition of table `factura`
--

DROP TABLE IF EXISTS `factura`;
CREATE TABLE `factura` (
  `id_factura` int(11) NOT NULL AUTO_INCREMENT,
  `mesa_id` int(11) NOT NULL,
  `fechaAlta` datetime NOT NULL,
  `total` decimal(10,2) NOT NULL DEFAULT '0.00',
  `pagado` varchar(1) DEFAULT '0',
  PRIMARY KEY (`id_factura`),
  KEY `fk_factura_mesa1_idx` (`mesa_id`),
  CONSTRAINT `fk_factura_mesa1` FOREIGN KEY (`mesa_id`) REFERENCES `mesa` (`id_mesa`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `factura`
--

/*!40000 ALTER TABLE `factura` DISABLE KEYS */;
INSERT INTO `factura` (`id_factura`,`mesa_id`,`fechaAlta`,`total`,`pagado`) VALUES 
 (4,2,'2022-09-20 14:04:45','81.00','1'),
 (5,1,'2022-09-20 14:12:04','45.00','1'),
 (6,3,'2022-09-20 18:56:38','0.00','1'),
 (7,1,'2022-09-20 19:40:10','6.00','1'),
 (8,12,'2022-09-20 19:53:09','14.00','1'),
 (9,1,'2022-09-20 21:19:58','25.00','1'),
 (10,1,'2022-09-20 21:22:27','63.75','1'),
 (11,11,'2022-09-21 13:44:12','10.00','1');
/*!40000 ALTER TABLE `factura` ENABLE KEYS */;


--
-- Definition of table `grupo`
--

DROP TABLE IF EXISTS `grupo`;
CREATE TABLE `grupo` (
  `id_grupo` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(10) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  PRIMARY KEY (`id_grupo`),
  UNIQUE KEY `idx1_grupo_codigo` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `grupo`
--

/*!40000 ALTER TABLE `grupo` DISABLE KEYS */;
INSERT INTO `grupo` (`id_grupo`,`codigo`,`nombre`) VALUES 
 (1,'beb01','Refrescos'),
 (2,'com01','Platos Combinados'),
 (3,'pos01','Postres'),
 (4,'beb02','Cervezas'),
 (5,'com02','Sandwich'),
 (6,'com03','Primeros'),
 (7,'com04','Segundos'),
 (8,'beb03','Combinados'),
 (9,'com00','Tapas Raciones');
/*!40000 ALTER TABLE `grupo` ENABLE KEYS */;


--
-- Definition of table `mesa`
--

DROP TABLE IF EXISTS `mesa`;
CREATE TABLE `mesa` (
  `id_mesa` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(10) NOT NULL,
  `activa` varchar(1) CHARACTER SET armscii8 NOT NULL DEFAULT '1',
  `ocupada` varchar(1) NOT NULL DEFAULT '0',
  `factura_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_mesa`),
  KEY `fk_mesa_factura_idx` (`factura_id`),
  CONSTRAINT `fk_mesa_factura` FOREIGN KEY (`factura_id`) REFERENCES `factura` (`id_factura`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `mesa`
--

/*!40000 ALTER TABLE `mesa` DISABLE KEYS */;
INSERT INTO `mesa` (`id_mesa`,`codigo`,`activa`,`ocupada`,`factura_id`) VALUES 
 (1,'Mesa 01','1','0',NULL),
 (2,'Mesa 02','1','0',NULL),
 (3,'Mesa 03','1','0',NULL),
 (4,'Mesa 04','1','0',NULL),
 (5,'Mesa 05','1','0',NULL),
 (6,'Mesa 06','1','0',NULL),
 (7,'Mesa 07','1','0',NULL),
 (8,'Mesa 08','1','0',NULL),
 (9,'Mesa 09','1','0',NULL),
 (10,'Mesa 10','1','0',NULL),
 (11,'Mesa 11','1','0',NULL),
 (12,'Mesa 12','1','0',NULL),
 (13,'Mesa 13','1','0',NULL),
 (14,'Mesa 1','1','0',NULL);
/*!40000 ALTER TABLE `mesa` ENABLE KEYS */;


--
-- Definition of table `producto`
--

DROP TABLE IF EXISTS `producto`;
CREATE TABLE `producto` (
  `id_producto` int(11) NOT NULL AUTO_INCREMENT,
  `grupo_id` int(11) NOT NULL,
  `codigo` varchar(10) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  `precio` decimal(10,2) NOT NULL,
  `activo` varchar(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id_producto`),
  UNIQUE KEY `idx1_codigo` (`codigo`),
  UNIQUE KEY `idx2_nombre` (`nombre`),
  KEY `fk_producto_grupo1_idx` (`grupo_id`),
  CONSTRAINT `fk_producto_grupo1` FOREIGN KEY (`grupo_id`) REFERENCES `grupo` (`id_grupo`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `producto`
--

/*!40000 ALTER TABLE `producto` DISABLE KEYS */;
INSERT INTO `producto` (`id_producto`,`grupo_id`,`codigo`,`nombre`,`precio`,`activo`) VALUES 
 (1,1,'CocaCola','Coca cola','2.50','1'),
 (2,4,'Caña','Cerveza Mahou','2.00','1'),
 (3,9,'papa01','Patatas Bravas','3.50','1'),
 (4,3,'flan','Flan de huevo','3.00','1'),
 (5,4,'tercio ','Tercio de Mahou','2.50','1'),
 (6,9,'champiñon','Champiñón al ajillo','8.00','1'),
 (7,2,'huevo+lomo','Lomo con huevos fritos','6.50','1'),
 (8,5,'jamon','Jamón York y queso','4.00','1'),
 (9,6,'judias ver','Judias verdes reogadas','5.00','1'),
 (10,6,'ensal. mix','Ensalada Mixta','3.50','1'),
 (11,7,'filete ter','Filete de ternera y papas','8.00','1'),
 (12,7,'filete cer','Lomos plancha y papas','6.00','1'),
 (13,3,'fruta','Fruta del tiempo','3.75','1');
/*!40000 ALTER TABLE `producto` ENABLE KEYS */;


--
-- Definition of table `restaurant_uggroups`
--

DROP TABLE IF EXISTS `restaurant_uggroups`;
CREATE TABLE `restaurant_uggroups` (
  `GroupID` int(11) NOT NULL AUTO_INCREMENT,
  `Label` varchar(300) DEFAULT NULL,
  `Provider` varchar(10) NOT NULL DEFAULT '',
  `Comment` mediumtext,
  PRIMARY KEY (`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `restaurant_uggroups`
--

/*!40000 ALTER TABLE `restaurant_uggroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `restaurant_uggroups` ENABLE KEYS */;


--
-- Definition of table `restaurant_ugmembers`
--

DROP TABLE IF EXISTS `restaurant_ugmembers`;
CREATE TABLE `restaurant_ugmembers` (
  `UserName` varchar(255) NOT NULL,
  `GroupID` int(11) NOT NULL,
  `Provider` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`UserName`(50),`GroupID`,`Provider`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `restaurant_ugmembers`
--

/*!40000 ALTER TABLE `restaurant_ugmembers` DISABLE KEYS */;
INSERT INTO `restaurant_ugmembers` (`UserName`,`GroupID`,`Provider`) VALUES 
 ('admin',-1,'');
/*!40000 ALTER TABLE `restaurant_ugmembers` ENABLE KEYS */;


--
-- Definition of table `restaurant_ugrights`
--

DROP TABLE IF EXISTS `restaurant_ugrights`;
CREATE TABLE `restaurant_ugrights` (
  `TableName` varchar(255) NOT NULL,
  `GroupID` int(11) NOT NULL,
  `AccessMask` varchar(10) DEFAULT NULL,
  `Page` mediumtext,
  PRIMARY KEY (`TableName`(50),`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `restaurant_ugrights`
--

/*!40000 ALTER TABLE `restaurant_ugrights` DISABLE KEYS */;
INSERT INTO `restaurant_ugrights` (`TableName`,`GroupID`,`AccessMask`,`Page`) VALUES 
 ('consumido',-2,'AEDSP',''),
 ('consumido',-1,'ADESPIM',NULL),
 ('factura',-2,'AEDSPI',''),
 ('factura',-1,'ADESPIM',NULL),
 ('grupo',-1,'ADESPIM',NULL),
 ('mesa',-1,'ADESPIM',NULL),
 ('producto',-1,'ADESPIM',NULL),
 ('usuario',-1,'ADESPIM',NULL),
 ('v_mesa',-2,'S',''),
 ('v_mesa',-1,'ADESPIM',NULL);
/*!40000 ALTER TABLE `restaurant_ugrights` ENABLE KEYS */;


--
-- Definition of table `usuario`
--

DROP TABLE IF EXISTS `usuario`;
CREATE TABLE `usuario` (
  `id_usuario` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(16) NOT NULL,
  `password` varchar(100) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `activo` varchar(1) NOT NULL DEFAULT '1',
  `fechaAlta` datetime NOT NULL,
  `fechaBaja` datetime DEFAULT NULL,
  PRIMARY KEY (`id_usuario`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `usuario`
--

/*!40000 ALTER TABLE `usuario` DISABLE KEYS */;
INSERT INTO `usuario` (`id_usuario`,`login`,`password`,`nombre`,`activo`,`fechaAlta`,`fechaBaja`) VALUES 
 (1,'admin','21232f297a57a5a743894a0e4a801fc3','Administrador','1','2022-09-18 20:41:00',NULL),
 (2,'waiter1','27fa0d15b06cfc0f573d11b49c7e8414','Camarero 1','1','2022-09-20 19:39:08',NULL);
/*!40000 ALTER TABLE `usuario` ENABLE KEYS */;




/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
